/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.updates;

import com.ibm.hsc.auiml.databeans.ucode.RepositoryItem;
import com.ibm.hsc.auiml.databeans.updates.MesUpgradeBean;
import com.ibm.hsc.websm.updates.DisplayLicenseForUpdatesExit;
import com.ibm.hsc.websm.updates.FirmwareUpdateConstants;
import com.ibm.hsc.websm.updates.PIUpdateErrorIds;
import com.ibm.hsc.websm.updates.PIUpdateException;
import com.ibm.hsc.websm.updates.PIUpdateableComponent;
import com.ibm.hsc.websm.updates.PIUpdater;
import com.ibm.hsc.websm.updates.PIUpdatesOwner;
import com.ibm.hsc.websm.updates.UpdatePanelUtilities;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.AlreadyBusyException;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaServicesUtil;
import com.ibm.hwmca.fw.mediasvc.MediaServicesUtilException;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.report.CompletionReportCode;
import com.ibm.hwmca.fw.report.IntermediateReport;
import com.ibm.hwmca.fw.report.StepReport;
import com.ibm.hwmca.fw.task.HwmcaPanelTasklet;
import com.ibm.hwmca.fw.task.ProgressCancelListener;
import com.ibm.hwmca.fw.task.ProgressData;
import com.ibm.hwmca.fw.task.ProgressEndedListener;
import com.ibm.hwmca.fw.task.ProgressListener;
import com.ibm.hwmca.fw.task.ProgressReportListenerImpl;
import com.ibm.hwmca.fw.task.ProgressStartEvent;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletProgressListener;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.UpdaterEvent;
import com.ibm.hwmca.xfw.updates.UpdaterListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MesUpgradeTasklet
extends HwmcaPanelTasklet
implements FirmwareUpdateConstants,
PIUpdateErrorIds,
UpdaterListener,
ProgressEndedListener {
    private static final String TRACE_MASKT = "XUPDMUTT";
    private static final String TRACE_MASKF = "XUPDMUTF";
    private static final String TRACE_MASKD = "XUPDMUTD";
    private ManagedObject[] initialTargets;
    int numTargets;
    PIUpdatesOwner[] piUpdOwner;
    private RepositoryItem reposItem;
    boolean isBusyDialogDisplayed = false;
    List[] updComponentsListArray;
    private MediaServicesUtil savedMediaServUtil = null;
    private boolean progressDismissed;
    private ProgressReportListenerImpl reportListener = null;
    private static final String PROGRESS_PANEL_ID = "MesUpgradeProgID";
    private static FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(2, "MesUpgradeTasklet");

    public MesUpgradeTasklet() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> MesUpgradeTasklet constructor");
        this.setExplicitTerminate(true);
        Trace.trace((String)TRACE_MASKT, (Object)"<- MesUpgradeTasklet constructor");
    }

    public void service(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        block32: {
            Trace.trace((String)TRACE_MASKT, (Object)"-> MesUpgradeTasklet.service()");
            try {
                if (panelTaskletRequest.isDisposed() || panelTaskletRequest.isCanceled()) {
                    Trace.trace((String)TRACE_MASKF, (Object)" [MesUpgradeTasklet.service()] Terminate task because the MES Upgrade confirmation panel is being disposed.");
                    panelTaskletResponse.terminate();
                    break block32;
                }
                if (panelTaskletRequest.isInitialRequest()) {
                    MesUpgradeBean mesUpgradeBean;
                    int n;
                    Trace.trace((String)TRACE_MASKF, (Object)" [MesUpgradeTasklet.service()] Handle initial request");
                    this.displayBusyDialog(true);
                    ObjectId[] objectIdArray = this.getPresentationTaskParms().getTargetIds();
                    this.initialTargets = (ManagedObject[])this.getObjectsForIds(objectIdArray);
                    this.numTargets = this.initialTargets.length;
                    int n2 = 1;
                    this.reposItem = new RepositoryItem(n2);
                    Trace.trace((String)TRACE_MASKD, (Object)(" [MesUpgradeTasklet.service()]  RepositoryItem created with repos location: " + this.reposItem.getReposType()));
                    int n3 = this.reposItem.getReposType();
                    UpdatePanelUtilities.forceComponentListCreation(this.initialTargets);
                    this.piUpdOwner = new PIUpdatesOwner[this.numTargets];
                    for (n = 0; n < this.numTargets; ++n) {
                        ManagedObject managedObject = this.initialTargets[n];
                        Trace.trace((String)TRACE_MASKF, (Object)(" [MesUpgradeTasklet.service()] Task target (#" + n + " of " + this.numTargets + "): " + managedObject.getUIInfo().getName()));
                        this.piUpdOwner[n] = UpdatePanelUtilities.getPIOwnerForManagedObject(managedObject);
                    }
                    n = 0;
                    boolean bl = true;
                    List list = Collections.EMPTY_LIST;
                    try {
                        list = this.verifyAllTargetsOnTside();
                    }
                    catch (HException hException) {
                        bl = false;
                    }
                    if (bl) {
                        this.displayBusyDialog(false);
                        if (list.isEmpty()) {
                            Trace.trace((String)TRACE_MASKD, (Object)" [MesUpgradeTasklet.service()] Passed all targets on t-side test.");
                            boolean bl2 = true;
                            while (bl2) {
                                Object object;
                                if (n3 == 1) {
                                    Trace.trace((String)TRACE_MASKD, (Object)" [MesUpgradeTasklet.service()] Use media services to get DVD mount point.");
                                    object = this.getMediaDevice(this.getMediaServicesUtil(), 6, new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "MES_UPGRADE_TITLE"), false);
                                    if (null != object) {
                                        try {
                                            this.reposItem.setLocation(object.getMountPoint().getAbsolutePath());
                                        }
                                        catch (MediaDeviceException mediaDeviceException) {
                                            Trace.trace((String)TRACE_MASKT, (Object)(" [MesUpgradeTasklet.service()] caught exception working with DVD mount point: " + (Object)((Object)mediaDeviceException)));
                                            bl2 = false;
                                            this.showMessage("UPD8001", "UPD0016");
                                        }
                                    } else {
                                        Trace.trace((String)TRACE_MASKD, (Object)" [MesUpgradeTasklet.service()] User must have canceled from a media services dialog.");
                                        bl2 = false;
                                    }
                                }
                                if (!bl2) continue;
                                this.displayBusyDialog(true);
                                Trace.trace((String)TRACE_MASKF, (Object)" [MesUpgradeTasklet.service()]  Run the survey.");
                                this.updComponentsListArray = this.runSurvey();
                                if (n3 == 1) {
                                    this.releaseMediaDeviceLock();
                                    this.reposItem.setLocation(null);
                                }
                                if ((object = this.verifyApplicableUpgrade()).size() == this.numTargets) {
                                    Trace.trace((String)TRACE_MASKD, (Object)" [MesUpgradeTasklet.service()] Must be invalid MES Upgrade DVD.");
                                    mesUpgradeBean = this.showMessage("UPD8001", "UPD0017", new String[]{CommonMsgApp.OK_BUTTON.toString()}, new LocalizableText[]{CommonMsgApp.OK_BUTTON, CommonMsgApp.CANCEL_BUTTON});
                                    Trace.trace((String)TRACE_MASKD, (Object)(" [MesUpgradeTasklet.service()] Button pressed on 'Insert new DVD' message box was '" + mesUpgradeBean + "'"));
                                    if (null == mesUpgradeBean || !mesUpgradeBean.toString().equals(CommonMsgApp.CANCEL_BUTTON.toString())) continue;
                                    bl2 = false;
                                    continue;
                                }
                                if (object.size() > 0) {
                                    Trace.trace((String)TRACE_MASKD, (Object)" [MesUpgradeTasklet.service()] Failed test of all targets having applicable upgrade.");
                                    this.showMessage("UPD8004", "UPD0018", new String[]{this.getTargetNames((List)object)}, null);
                                    bl2 = false;
                                    continue;
                                }
                                Trace.trace((String)TRACE_MASKD, (Object)" [MesUpgradeTasklet.service()] Passed test of all targets having applicable upgrade.");
                                Trace.trace((String)TRACE_MASKD, (Object)" [MesUpgradeTasklet.service()] All tests were successful.");
                                bl2 = false;
                                n = 1;
                            }
                        } else {
                            Trace.trace((String)TRACE_MASKD, (Object)" [MesUpgradeTasklet.service()] Failed all targets on t-side test.");
                            this.showMessage("UPD8004", "UPD0014", new String[]{this.getTargetNames(list)}, null);
                        }
                    }
                    this.displayBusyDialog(false);
                    if (n != 0) {
                        Trace.trace((String)TRACE_MASKD, (Object)" [MesUpgradeTasklet.service()] showConfirmationPanel set to true.");
                        List list2 = Collections.EMPTY_LIST;
                        try {
                            list2 = this.verifyAllTargetsInStandbyState();
                        }
                        catch (HException hException) {
                            bl = false;
                        }
                        if (bl) {
                            boolean bl3 = this.displayLicenseAgreement();
                            if (!bl3) {
                                Trace.trace((String)TRACE_MASKT, (Object)" [MesUpgradeTasklet.service()] Terminate task because user didn't accept license.");
                                panelTaskletResponse.terminate();
                            } else {
                                Trace.trace((String)TRACE_MASKF, (Object)" [MesUpgradeTasklet.service()] License accepted. Prepare the confirm panel.");
                                mesUpgradeBean = new MesUpgradeBean();
                                List list3 = this.getECTableData();
                                if (list3.size() > 0) {
                                    mesUpgradeBean.setECTableList(list3);
                                }
                                if (list2.isEmpty()) {
                                    Trace.trace((String)TRACE_MASKD, (Object)" [MesUpgradeTasklet.service()] All targets are in standby state.");
                                } else {
                                    Trace.trace((String)TRACE_MASKD, (Object)" [MesUpgradeTasklet.service()] Some targets are not in standby state.");
                                    List list4 = this.getQuiesceTableData(list2);
                                    if (list4.size() > 0) {
                                        mesUpgradeBean.setQuiesceTableList(list4);
                                    }
                                }
                                Trace.trace((String)TRACE_MASKD, (Object)" [MesUpgradeTasklet.service()] Display confirmation panel.");
                                panelTaskletResponse.replace("com.ibm.hsc.auiml.databeans.updates.FirmwareRes", "MesUpgradePanel", (PanelBean)mesUpgradeBean);
                            }
                        } else {
                            Trace.trace((String)TRACE_MASKF, (Object)" [MesUpgradeTasklet.service()] Terminate task.");
                            panelTaskletResponse.terminate();
                        }
                        break block32;
                    }
                    Trace.trace((String)TRACE_MASKF, (Object)" [MesUpgradeTasklet.service()] Terminate task.");
                    panelTaskletResponse.terminate();
                    break block32;
                }
                if (null != (String)panelTaskletRequest.getData("terminate")) {
                    Trace.trace((String)TRACE_MASKF, (Object)" [MesUpgradeTasklet.service()] Terminate task because work has completed.");
                    panelTaskletResponse.terminate();
                } else {
                    Trace.trace((String)TRACE_MASKF, (Object)" [MesUpgradeTasklet.service()] User confirmed to proceed with MES Upgrade.");
                    Runnable runnable = new Runnable(){

                        public void run() {
                            Trace.trace((String)MesUpgradeTasklet.TRACE_MASKT, (Object)"-> MesUpgradeTasklet.runUpgrade.run()");
                            MesUpgradeTasklet.this.doUpgrade();
                            Trace.trace((String)MesUpgradeTasklet.TRACE_MASKT, (Object)"<- MesUpgradeTasklet.runUpgrade().run()");
                        }
                    };
                    Thread thread = new Thread(runnable, "MesUpgradeTasklet upgrade");
                    thread.setDaemon(true);
                    thread.start();
                    panelTaskletResponse.dispose();
                }
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKT, (Object)(" [MesUpgradeTasklet.service()] caught exception: " + exception));
                new FrameworkLog(classLogInfo, -1607, (Throwable)exception).log();
                this.releaseMediaDeviceLock();
                Trace.trace((String)TRACE_MASKT, (Object)" [MesUpgradeTasklet.service()] Terminate task due to nonrecoverable error.");
                panelTaskletResponse.terminate();
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- MesUpgradeTasklet.service()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpgrade() {
        PanelTaskletRequest panelTaskletRequest;
        Trace.trace((String)TRACE_MASKT, (Object)"-> MesUpgradeTasklet.doUpgrade()");
        boolean bl = true;
        int n = this.reposItem.getReposType();
        if (n == 1) {
            panelTaskletRequest = this.getMediaDevice(this.getMediaServicesUtil(), 6, new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "MES_UPGRADE_TITLE"), false);
            if (null != panelTaskletRequest) {
                try {
                    this.reposItem.setLocation(panelTaskletRequest.getMountPoint().getAbsolutePath());
                }
                catch (MediaDeviceException mediaDeviceException) {
                    Trace.trace((String)TRACE_MASKT, (Object)(" [doUpgrade()] caught exception: " + (Object)((Object)mediaDeviceException)));
                    bl = false;
                    this.showMessage("UPD8001", "UPD0016");
                }
            } else {
                bl = false;
            }
        }
        if (bl) {
            panelTaskletRequest = new PIUpdater[this.numTargets];
            ProgressData[] progressDataArray = new ProgressData[this.numTargets];
            ObjectId[] objectIdArray = new ObjectId[this.numTargets];
            Trace.trace((String)TRACE_MASKF, (Object)(" [MesUpgradeTasklet.doUpgrade()] - about to start the upgrade loop for " + this.numTargets + " managed objects"));
            for (int i = 0; i < this.numTargets; ++i) {
                long l = 0L;
                objectIdArray[i] = this.initialTargets[i].getObjectId();
                if (null == this.piUpdOwner[i]) {
                    panelTaskletRequest[i] = null;
                } else {
                    panelTaskletRequest[i] = (PIUpdater)this.piUpdOwner[i].getUpdaterInstance();
                    panelTaskletRequest[i].addUpdaterListener((UpdaterListener)this);
                    panelTaskletRequest[i].setAttachment((Object)objectIdArray[i]);
                }
                progressDataArray[i] = new ProgressData(new LocalizableText(this.initialTargets[i].getUIInfo().getName()), objectIdArray[i], l);
            }
            PanelTaskletProgressListener panelTaskletProgressListener = new PanelTaskletProgressListener((PanelTasklet)this);
            ProgressStartEvent progressStartEvent = new ProgressStartEvent(new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "MES_UPGRADE_TITLE"), progressDataArray, 0L, new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "PROGRESS_PANEL_STARTING_OPERATION"), PROGRESS_PANEL_ID, (ProgressCancelListener)null, (ProgressEndedListener)this);
            panelTaskletProgressListener.startProgress(progressStartEvent);
            this.reportListener = new ProgressReportListenerImpl(PROGRESS_PANEL_ID, objectIdArray, (ProgressListener)panelTaskletProgressListener);
            Trace.trace((String)TRACE_MASKF, (Object)" [MesUpgradeTasklet.doUpgrade()] Starting upgrade operation for each target object.");
            MesUpgradeTasklet mesUpgradeTasklet = this;
            synchronized (mesUpgradeTasklet) {
                for (int i = 0; i < this.numTargets; ++i) {
                    Trace.trace((String)TRACE_MASKD, (Object)(" [MesUpgradeTasklet.doUpgrade()] processing updater #" + i));
                    if (null != this.piUpdOwner[i]) {
                        MessageText messageText;
                        CompletionReport completionReport;
                        try {
                            panelTaskletRequest[i].applyUpgrade(this.reposItem);
                        }
                        catch (AlreadyBusyException alreadyBusyException) {
                            completionReport = new CompletionReport(objectIdArray[i]);
                            completionReport.setCompletionCode(CompletionReportCode.FAIL);
                            messageText = panelTaskletRequest[i].getLastMessage();
                            if (null == messageText) {
                                messageText = new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "PROGRESS_PANEL_ERROR_PROCESSING");
                            }
                            completionReport.setData((Object)messageText);
                            this.reportListener.completeReport(completionReport);
                        }
                        catch (HException hException) {
                            completionReport = new CompletionReport(objectIdArray[i]);
                            completionReport.setCompletionCode(CompletionReportCode.FAIL);
                            messageText = panelTaskletRequest[i].getLastMessage();
                            if (null == messageText) {
                                messageText = new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "PROGRESS_PANEL_ERROR_PROCESSING");
                            }
                            completionReport.setData((Object)messageText);
                            this.reportListener.completeReport(completionReport);
                        }
                        continue;
                    }
                    CompletionReport completionReport = new CompletionReport(objectIdArray[i]);
                    completionReport.setCompletionCode(CompletionReportCode.FAIL);
                    completionReport.setData((Object)new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "PROGRESS_PANEL_CANNOT_UPDATE"));
                    this.reportListener.completeReport(completionReport);
                }
                this.progressDismissed = false;
                while (!this.progressDismissed) {
                    try {
                        Trace.trace((String)TRACE_MASKF, (Object)" [MesUpgradeTasklet.doUpgrade()] entering wait()");
                        this.wait();
                        Trace.trace((String)TRACE_MASKF, (Object)" [MesUpgradeTasklet.doUpgrade()] leaving wait()");
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            Trace.trace((String)TRACE_MASKF, (Object)" [MesUpgradeTasklet.doUpgrade()] progress window has been dismissed");
        }
        if (n == 1) {
            this.releaseMediaDeviceLock();
            this.reposItem.setLocation(null);
        }
        panelTaskletRequest = new PanelTaskletRequest();
        panelTaskletRequest.setData("terminate", (Object)"terminate");
        try {
            this.postRequest(null, panelTaskletRequest);
        }
        catch (TaskletException taskletException) {
            this.logException(taskletException);
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- MesUpgradeTasklet.doUpgrade()");
    }

    private List verifyAllTargetsOnTside() throws HException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> MesUpgradeTasklet.verifyAllTargetsOnTside()");
        ArrayList<ManagedObject> arrayList = new ArrayList<ManagedObject>(this.numTargets);
        for (int i = 0; i < this.numTargets; ++i) {
            PIUpdatesOwner pIUpdatesOwner = this.piUpdOwner[i];
            try {
                if (null == pIUpdatesOwner || pIUpdatesOwner.isTSideActive()) continue;
                arrayList.add(this.initialTargets[i]);
                Trace.trace((String)TRACE_MASKF, (Object)(" [verifyAllTargetsOnTside()] Found target '" + this.initialTargets[i].getUIInfo().getName() + "' failing t-side active test."));
                continue;
            }
            catch (HException hException) {
                Trace.trace((String)TRACE_MASKT, (Object)(" [verifyAllTargetsOnTside()] caught exception: " + (Object)((Object)hException)));
                this.showMessage("UPD8004", "UPD0015", new String[]{this.initialTargets[i].getUIInfo().getName()}, null);
                throw hException;
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- MesUpgradeTasklet.verifyAllTargetsOnTside(), targetsNotRunningOnTside size: " + arrayList.size()));
        return arrayList.size() > 0 ? arrayList : Collections.EMPTY_LIST;
    }

    private List verifyApplicableUpgrade() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> MesUpgradeTasklet.verifyApplicableUpgrade()");
        ArrayList<ManagedObject> arrayList = new ArrayList<ManagedObject>(this.numTargets);
        for (int i = 0; i < this.numTargets; ++i) {
            boolean bl = false;
            List list = this.updComponentsListArray[i];
            Trace.trace((String)TRACE_MASKD, (Object)(" [verifyApplicableUpgrade()] Target '" + this.initialTargets[i].getUIInfo().getName() + "' has " + list.size() + " associated updateable components."));
            int n = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PIUpdateableComponent pIUpdateableComponent = (PIUpdateableComponent)iterator.next();
                Trace.trace((String)TRACE_MASKD, (Object)(" [verifyApplicableUpgrade()] Processing component #" + n + ", " + pIUpdateableComponent.getName()));
                String string = pIUpdateableComponent.getNewGAEcStream();
                if (null != string) {
                    Trace.trace((String)TRACE_MASKD, (Object)" [verifyApplicableUpgrade()] Found a component that can upgrade its GA level.");
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) continue;
            arrayList.add(this.initialTargets[i]);
            Trace.trace((String)TRACE_MASKF, (Object)(" [verifyApplicableUpgrade()] Found target '" + this.initialTargets[i].getUIInfo().getName() + "' without any applicable upgrades."));
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- MesUpgradeTasklet.verifyApplicableUpgrade(), targetsWithoutUpgrade size: " + arrayList.size()));
        return arrayList.size() > 0 ? arrayList : Collections.EMPTY_LIST;
    }

    private List verifyAllTargetsInStandbyState() throws HException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> MesUpgradeTasklet.verifyAllTargetsInStandbyState()");
        ArrayList<ManagedObject> arrayList = new ArrayList<ManagedObject>(this.numTargets);
        for (int i = 0; i < this.numTargets; ++i) {
            PIUpdatesOwner pIUpdatesOwner = this.piUpdOwner[i];
            try {
                if (null == pIUpdatesOwner || pIUpdatesOwner.isStandbyState()) continue;
                arrayList.add(this.initialTargets[i]);
                Trace.trace((String)TRACE_MASKF, (Object)(" [verifyAllTargetsInStandbyState()] Found target '" + this.initialTargets[i].getUIInfo().getName() + "' failing standby state test."));
                continue;
            }
            catch (HException hException) {
                Trace.trace((String)TRACE_MASKT, (Object)(" [verifyAllTargetsInStandbyState()] caught exception: " + (Object)((Object)hException)));
                this.showMessage("UPD8004", "UPD0015", new String[]{this.initialTargets[i].getUIInfo().getName()}, null);
                throw hException;
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- MesUpgradeTasklet.verifyAllTargetsInStandbyState(), targetsNotInStandby size: " + arrayList.size()));
        return arrayList.size() > 0 ? arrayList : Collections.EMPTY_LIST;
    }

    private List[] runSurvey() throws HException {
        List[] listArray = new List[this.numTargets];
        for (int i = 0; i < this.numTargets; ++i) {
            try {
                listArray[i] = UpdatePanelUtilities.doSurvey(this.initialTargets[i], this.reposItem, false);
                continue;
            }
            catch (HException hException) {
                Trace.trace((String)TRACE_MASKT, (Object)(" [runSurvey] Caught exception: " + (Object)((Object)hException)));
                Trace.trace((String)TRACE_MASKD, (Object)(" [runSurvey()] target that failed: " + this.initialTargets[i].getUIInfo().getName()));
                if (hException instanceof PIUpdateException) {
                    MessageText messageText = ((PIUpdateException)hException).getMessageText();
                    try {
                        this.showMessageBox(true, new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundleMessages", "UPD8004"), messageText, MsgType.ERROR_MESSAGE, null);
                    }
                    catch (TaskletException taskletException) {
                        Trace.trace((String)TRACE_MASKF, (Object)" [runSurvey()] Exception working with message box!");
                    }
                } else {
                    this.showMessage("UPD8004", "UPD0004", new String[]{this.initialTargets[i].getUIInfo().getName()}, null);
                }
                throw hException;
            }
        }
        return listArray;
    }

    private void displayBusyDialog(boolean bl) {
        try {
            if (bl && !this.isBusyDialogDisplayed) {
                this.showBusyDialog(new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "CHANGE_INT_CODE_TITLE"), new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "PLEASE_WAIT"));
                this.isBusyDialogDisplayed = true;
            } else if (!bl && this.isBusyDialogDisplayed) {
                this.destroyBusyDialog();
                this.isBusyDialogDisplayed = false;
            }
        }
        catch (TaskletException taskletException) {
            Trace.trace((String)TRACE_MASKT, (Object)" [displayBusyDialog()] Caught exception: te");
        }
    }

    private String getTargetNames(List list) {
        String string = "";
        for (int i = 0; i < list.size(); ++i) {
            string = i != 0 ? string + ", " + ((ManagedObject)list.get(i)).getUIInfo().getName() : string + ((ManagedObject)list.get(i)).getUIInfo().getName();
        }
        return string;
    }

    private List getECTableData() {
        Trace.trace((String)TRACE_MASKD, (Object)"-> MesUpgradeTasklet.getECTableData()");
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (int i = 0; i < this.numTargets; ++i) {
            List list = this.updComponentsListArray[i];
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PIUpdateableComponent pIUpdateableComponent = (PIUpdateableComponent)iterator.next();
                String string = pIUpdateableComponent.getNewGAEcStream();
                if (null == string) continue;
                String[] stringArray = new String[]{this.initialTargets[i].getUIInfo().getName(), pIUpdateableComponent.getName(), pIUpdateableComponent.getMTMS(), pIUpdateableComponent.getECNumber(), string};
                Trace.trace((String)TRACE_MASKD, (Object)(" [getECTableData()] Adding row: " + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ", " + stringArray[3] + ", " + stringArray[4]));
                arrayList.add(stringArray);
            }
        }
        arrayList.trimToSize();
        Trace.trace((String)TRACE_MASKD, (Object)("<- MesUpgradeTasklet.getECTableData(), size: " + arrayList.size()));
        return arrayList.size() > 0 ? arrayList : Collections.EMPTY_LIST;
    }

    private List getQuiesceTableData(List list) {
        Trace.trace((String)TRACE_MASKD, (Object)"<> MesUpgradeTasklet.getQuiesceTableData()");
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedObject managedObject = (ManagedObject)iterator.next();
            arrayList.add(managedObject.getUIInfo().getName());
        }
        return arrayList.size() > 0 ? arrayList : Collections.EMPTY_LIST;
    }

    private boolean displayLicenseAgreement() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> MesUpgrageTasklet.displayLicenseAgreement()");
        boolean bl = false;
        Trace.trace((String)TRACE_MASKD, (Object)(" [displayLicenseAgreement()] client locale is: " + this.getClientInformation().getLocale()));
        DisplayLicenseForUpdatesExit displayLicenseForUpdatesExit = new DisplayLicenseForUpdatesExit();
        try {
            bl = (Boolean)this.invokeExitOnClient(displayLicenseForUpdatesExit);
        }
        catch (TaskletException taskletException) {
            Trace.trace((String)TRACE_MASKT, (Object)(" [displayLicenseAgreement()] caught tasklet exception: " + (Object)((Object)taskletException)));
            new FrameworkLog(classLogInfo, -1616, (Throwable)taskletException).log();
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- MesUpgradeTasklet.displayLicenseAgreement(), returning result: " + bl));
        return bl;
    }

    private void showMessage(String string, String string2) {
        this.showMessage(string, string2, null, null);
    }

    private LocalizableText showMessage(String string, String string2, String[] stringArray, LocalizableText[] localizableTextArray) {
        Trace.trace((String)TRACE_MASKT, (Object)("-> MesUpgradeTasklet.showMessage(), message key: " + string2));
        LocalizableText localizableText = null;
        this.displayBusyDialog(false);
        try {
            localizableText = this.showMessageBox(true, new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundleMessages", string), new MessageText("com.ibm.hsc.common.bundles.UpdatesBundleMessages", string2, (Object[])stringArray), null, localizableTextArray);
        }
        catch (TaskletException taskletException) {
            Trace.trace((String)TRACE_MASKF, (Object)" [showMessage()] Exception working with message box!");
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- MesUpgradeTasklet.showMessage(), returning: " + localizableText));
        return localizableText;
    }

    public void destroy() {
        Trace.trace((String)TRACE_MASKF, (Object)"<> MesUpgradeTasklet.destroy()");
        this.releaseMediaDeviceLock();
    }

    private MediaServicesUtil getMediaServicesUtil() {
        if (null == this.savedMediaServUtil) {
            this.savedMediaServUtil = new MediaServicesUtil((PanelTasklet)this);
        }
        return this.savedMediaServUtil;
    }

    private MediaDevice getMediaDevice(MediaServicesUtil mediaServicesUtil, int n, LocalizableText localizableText, boolean bl) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> MesUpgradeTasklet.getMediaDevice()");
        MediaDevice mediaDevice = null;
        try {
            mediaDevice = mediaServicesUtil.prepareMedia(n, localizableText, bl, null);
        }
        catch (MediaServicesUtilException mediaServicesUtilException) {
            Trace.trace((String)TRACE_MASKT, (Object)(" [getMediaDevice()] caught exception: " + (Object)((Object)mediaServicesUtilException)));
            Trace.trace((String)TRACE_MASKT, (Object)(" [getMediaDevice()] The exception type is: " + Integer.toString(mediaServicesUtilException.getErrorType())));
            if (mediaServicesUtilException.getErrorType() != 11) {
                this.showMessage("UPD8001", "UPD0016");
            }
            this.releaseMediaDeviceLock();
        }
        if (null == mediaDevice) {
            Trace.trace((String)TRACE_MASKD, (Object)" [getMediaDevice()] returning NULL for media device.");
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- MesUpgradeTasklet.getMediaDevice()");
        return mediaDevice;
    }

    private void releaseMediaDeviceLock() {
        if (null != this.savedMediaServUtil) {
            try {
                Trace.trace((String)TRACE_MASKD, (Object)" [MesUpgradeTasklet.releaseMediaDeviceLock()] Releasing media device lock.");
                this.savedMediaServUtil.releaseMedia();
            }
            catch (MediaServicesUtilException mediaServicesUtilException) {
                // empty catch block
            }
            this.savedMediaServUtil = null;
        }
    }

    public void logException(Throwable throwable) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> MesUpgradeTasklet.logException()");
        Trace.trace((String)TRACE_MASKT, (Object)("   processing exception: " + throwable));
        new FrameworkLog(classLogInfo, -1605, throwable).log();
        Trace.trace((String)TRACE_MASKT, (Object)"<- MesUpgradeTasklet.logException()");
    }

    public void operationCompleted(UpdaterEvent updaterEvent) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> MesUpgradeTasklet.operationCompleted()");
        PIUpdater pIUpdater = (PIUpdater)updaterEvent.getSource();
        ObjectId objectId = (ObjectId)pIUpdater.getAttachment();
        CompletionReport completionReport = new CompletionReport(objectId);
        int n = updaterEvent.getCompletionStatus();
        LocalizableText localizableText = updaterEvent.getMessage();
        Trace.trace((String)TRACE_MASKF, (Object)("   MesUpgradeTasklet.operationCompleted()   PIUpdater: [" + pIUpdater + "]," + "   objectId: [" + objectId + "]," + "   status: [" + n + "],"));
        if (null != localizableText) {
            Trace.trace((String)TRACE_MASKF, (Object)("   msg: [" + localizableText + "]"));
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)" [operationCompleted()] The completion message is null.");
        }
        if (44 == n) {
            Trace.trace((String)TRACE_MASKD, (Object)" [operationCompleted()] This is a partially successful completion.");
            completionReport.setCompletionCode(CompletionReportCode.PARTIAL_SUCCESS);
            LocalizableText localizableText2 = updaterEvent.getDetailsMessage();
            if (null != localizableText2) {
                localizableText = localizableText2;
                Trace.trace((String)TRACE_MASKF, (Object)(" [operationCompleted()] The detailed message is '" + localizableText + "'."));
            }
            completionReport.setData((Object)localizableText);
        } else if (2 == n) {
            Trace.trace((String)TRACE_MASKD, (Object)" [operationCompleted()] This is a failure completion.");
            completionReport.setCompletionCode(CompletionReportCode.FAIL);
            LocalizableText localizableText3 = updaterEvent.getDetailsMessage();
            if (null != localizableText3) {
                localizableText = localizableText3;
                Trace.trace((String)TRACE_MASKF, (Object)(" [operationCompleted()] The detailed message is '" + localizableText + "'."));
            }
            completionReport.setData((Object)localizableText);
        } else {
            completionReport.setCompletionCode(CompletionReportCode.SUCCESS);
            completionReport.setText(localizableText);
        }
        this.reportListener.completeReport(completionReport);
        Trace.trace((String)TRACE_MASKT, (Object)"<- MesUpgradeTasklet.operationCompleted()");
    }

    public void operationProgressing(UpdaterEvent updaterEvent) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> MesUpgradeTasklet.operationProgressing()");
        PIUpdater pIUpdater = (PIUpdater)updaterEvent.getSource();
        ObjectId objectId = (ObjectId)pIUpdater.getAttachment();
        LocalizableText localizableText = new LocalizableText(updaterEvent.getMessage().toString());
        Trace.trace((String)TRACE_MASKF, (Object)("   MesUpgradeTasklet.operationProgressing()   PIUpdater: [" + pIUpdater + "]," + "   objectId: [" + objectId + "]," + "   msg: [" + localizableText + "]"));
        this.reportListener.intermediateReport((IntermediateReport)new StepReport(objectId, localizableText));
        Trace.trace((String)TRACE_MASKT, (Object)"<- MesUpgradeTasklet.operationProgressing()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressEnded(String string) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> MesUpgradeTasklet.progressEnded()");
        MesUpgradeTasklet mesUpgradeTasklet = this;
        synchronized (mesUpgradeTasklet) {
            this.progressDismissed = true;
            Trace.trace((String)TRACE_MASKF, (Object)" [MesUpgradeTasklet.progressEnded()] entering notifyAll()");
            this.notifyAll();
            Trace.trace((String)TRACE_MASKF, (Object)" [progressEnded()] leaving notifyAll()");
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- MesUpgradeTasklet.progressEnded()");
    }
}

